/**
 * ./src/classes/diversions.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import Distro from './distro.js';
export default class Diversions {
    /**
     *
     * @param familyId
     * @returns
     */
    static isSystemDBoot(familyId, isEfi) {
        let isSystemDBoot = false;
        if (familyId === 'fedora' && isEfi) {
            isSystemDBoot = true;
        }
        return isSystemDBoot;
    }
    /**
     *
     * @param familyId
     * @returns deluser
     */
    static deluser(familyId) {
        let deluser = 'deluser';
        if (familyId === 'aldos' ||
            familyId === 'archlinux' ||
            familyId === 'fedora' ||
            familyId === 'openmamba' ||
            familyId === 'opensuse' ||
            familyId === 'voidlinux') {
            deluser = 'userdel';
        }
        return deluser;
    }
    /**
     *
     * @param familyId
     * @returns
     */
    static grubName(familyId) {
        let grubName = 'grub';
        if (familyId === 'aldos' ||
            familyId === 'fedora' ||
            familyId === 'opensuse') {
            grubName = 'grub2';
        }
        return grubName;
    }
    /**
     * grubForce
     */
    static grubForce(familyId) {
        let grubForce = '';
        if (familyId === 'aldos' || familyId === 'fedora') {
            grubForce = '--force';
        }
        return grubForce;
    }
    /**
     *
     * @param familyId
     * @param volid
     * @returns
     */
    static kernelParameters(familyId, volid, luksUuid = '', fullCrypt = false) {
        // GRUB_CMDLINE_LINUX='ipv6.disable=1'
        let kp = "";
        if (familyId === 'alpine') {
            kp += `alpinelivelabel=${volid} alpinelivesquashfs=/mnt/live/filesystem.squashfs`;
        }
        else if (familyId === 'archlinux') {
            kp += `boot=live components locales=${process.env.LANG}`;
            const distroId = this.distro().distroId;
            if (this.isManjaroBased(distroId)) {
                kp += ` misobasedir=manjaro misolabel=${volid}`;
            }
            else {
                kp += ` archisobasedir=arch archisolabel=${volid}`;
            }
        }
        else if (familyId === 'debian') {
            kp += `boot=live components locales=${process.env.LANG} cow_spacesize=2G`;
            if (fullCrypt) {
                kp += ` live-media=/run/live/medium`;
            }
        }
        else if (familyId === 'fedora') {
            kp += `root=live:CDLABEL=${volid} rd.live.image rd.live.dir=/live rd.live.squashimg=filesystem.squashfs selinux=0`;
        }
        else if (familyId === 'openmamba') {
            kp += `root=live:CDLABEL=${volid} rd.live.image rd.live.dir=/live rd.live.squashimg=filesystem.squashfs selinux=0`;
        }
        else if (familyId === 'opensuse') {
            kp += `root=live:CDLABEL=${volid} rd.live.image rd.live.dir=/live rd.live.squashimg=filesystem.squashfs apparmor=0`;
        }
        else if (familyId === 'voidlinux') {
            kp += `root=live:CDLABEL=${volid} rd.live.image rd.live.dir=/live rd.live.squashimg=filesystem.squashfs rd.debug`;
        }
        return kp;
    }
    /**
       *
       * @returns
       */
    static distro() {
        return new Distro();
    }
    /**
    * isManjaroBased
    */
    static isManjaroBased(distro) {
        let found = false;
        if (distro === 'Manjaro' ||
            distro === `Biglinux` ||
            distro === `Bigcommunity`) {
            found = true;
        }
        return found;
    }
    static bootloaders(familyId) {
        let bootloaders = '/usr/lib/';
        if (familyId !== 'debian') {
            bootloaders = '/usr/lib/penguins-eggs/bootloaders/';
        }
        return bootloaders;
    }
}
