import { getSmithyContext } from "@smithy/util-middleware";
import { hydrate, isStaticSchema } from "../schemas/NormalizedSchema";
export const schemaSerializationMiddleware = (config) => (next, context) => async (args) => {
    let { operationSchema } = getSmithyContext(context);
    if (isStaticSchema(operationSchema)) {
        operationSchema = hydrate(operationSchema);
    }
    const endpoint = context.endpointV2?.url && config.urlParser
        ? async () => config.urlParser(context.endpointV2.url)
        : config.endpoint;
    const request = await config.protocol.serializeRequest(operationSchema, args.input, {
        ...config,
        ...context,
        endpoint,
    });
    return next({
        ...args,
        request,
    });
};
