import { Buffer } from 'buffer';
interface DhcpOptions {
    [key: number]: any;
}
export declare class Packet {
    chaddr: string;
    ciaddr: string;
    flags: number;
    fname: string;
    giaddr: string;
    hlen: number;
    hops: number;
    htype: number;
    op: number;
    options: DhcpOptions;
    secs: number;
    siaddr: string;
    sname: string;
    xid: number;
    yiaddr: string;
    constructor(init: Partial<Packet>);
    /**
     * Crea un oggetto Packet da un Buffer
     * @param b Il Buffer da cui leggere
     * @returns Un'istanza di Packet
     */
    static fromBuffer(b: Buffer): Packet;
    getRequestedIPAddress(): string;
    op_set(op: number): this;
    /**
     * Converte l'oggetto Packet in un Buffer
     * @returns Il Buffer DHCP
     */
    toBuffer(): Buffer;
}
export {};
