import { select } from '@inquirer/prompts';
import Locales from '../../classes/locales.js';
export default async function selectLanguages(selectedLanguage = '') {
    const locales = new Locales();
    const supported = await locales.getSupported();
    const selected = selectedLanguage;
    const choices = supported.map((l) => ({ name: l, value: l }));
    const answer = await select({
        message: 'Select language: ',
        choices,
        default: selected,
    });
    return answer;
}
