/**
 * ./src/classes/ovary.d/initrd.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import fs from 'fs';
import path from 'node:path';
// classes
import { exec } from '../../lib/utils.js';
import Utils from '../utils.js';
import Diversions from '../diversions.js';
// _dirname
const __dirname = path.dirname(new URL(import.meta.url).pathname);
/**
 * initrdAlpine
 */
export async function initrdAlpine() {
    Utils.warning(`creating ${path.basename(this.initrd)} Alpine on (ISO)/live`);
    let initrdImg = Utils.initrdImg();
    initrdImg = initrdImg.slice(Math.max(0, initrdImg.lastIndexOf('/') + 1));
    const pathConf = path.resolve(__dirname, `../../../mkinitfs/live.conf`);
    const prefix = this.settings.config.snapshot_prefix;
    const log = `> ${this.settings.iso_work}${prefix}mkinitfs.log.txt 2>&1`;
    const cmd = `mkinitfs -c ${pathConf} -o ${this.settings.iso_work}live/${initrdImg} ${this.kernel} ${log}`;
    await exec(cmd, this.echo);
}
/**
 * initrdArch
 */
export async function initrdArch() {
    Utils.warning(`creating ${path.basename(this.initrd)} using mkinitcpio on (ISO)/live`);
    let dirConf = 'arch';
    let tool = 'archiso';
    let hookSrc = '/usr/lib/initcpio/hooks/archiso_pxe_http';
    let hookDest = '/etc/initcpio/hooks/archiso_pxe_http';
    let edit = `sed -i 's/export copytoram="y"/# export copytoram="y"/' ${hookDest}`;
    if (Diversions.isManjaroBased(this.distroId)) {
        dirConf = 'manjaro';
        tool = 'miso';
        hookSrc = `/etc/initcpio/hooks/miso_pxe_http`;
        hookDest = hookSrc;
        edit = `sed -i 's/copytoram="y"/# copytoram="y"/' ${hookDest}`;
        if (this.distroId === "Biglinux" || this.distroId === "Bigcommunity") {
            dirConf = 'biglinux';
        }
    }
    const restore = fs.existsSync(hookDest);
    const pathConf = path.resolve(__dirname, `../../../mkinitcpio/${dirConf}`);
    const fileConf = pathConf + '/live.conf';
    let hookSaved = `/tmp/${path.basename(hookSrc)}`;
    if (hookSrc !== hookDest) {
        await exec(`cp ${hookSrc} ${hookDest}`);
    }
    await exec(`cp ${hookSrc} ${hookSaved}`);
    await exec(edit, this.echo);
    const prefix = this.settings.config.snapshot_prefix;
    const log = `> ${this.settings.iso_work}${prefix}mkinitcpio.log.txt 2>&1`;
    let cmd = `mkinitcpio -c ${fileConf} -g ${this.settings.iso_work}live/${path.basename(this.initrd)} -k ${this.kernel} ${log}`;
    await exec(cmd, this.echo);
    await exec(`rm -f ${hookDest}`);
    if (restore) {
        await exec(`cp ${hookSaved} ${hookDest}`);
    }
    await exec(`rm -f ${hookSaved}`);
}
/**
 * initrdDebian
 */
export async function initrdDebian(verbose = false) {
    Utils.warning(`creating ${this.initrd} using mkinitramfs on (ISO)/live`);
    const prefix = this.settings.config.snapshot_prefix;
    const destFinal = `${this.settings.iso_work}live/${path.basename(this.initrd)}`;
    const log = `> ${this.settings.iso_work}${prefix}mkinitramfs.log.txt 2>&1`;
    const target = path.join(this.dotMnt, 'filesystem.squashfs');
    const cmd = `mkinitramfs -v -o ${destFinal} ${this.kernel} ${log}`;
    await exec(cmd, this.echo);
}
/*
* initrdDracut) Almalinux/Fedora/Openmamba/Opensuse/Rocky/
*/
export async function initrdDracut() {
    Utils.warning(`creating ${path.basename(this.initrd)} using dracut on (ISO)/live`);
    const prefix = this.settings.config.snapshot_prefix;
    const log = `> ${this.settings.iso_work}${prefix}dracut.log.txt 2>&1`;
    const confdir = '--confdir ' + path.resolve(__dirname, `../../../dracut/dracut.conf.d`);
    const kmoddir = `--kmoddir /lib/modules/${this.kernel}`;
    const initramfs = `${this.settings.iso_work}live/${path.basename(this.initrd)}`;
    const cmd = `dracut --force ${confdir} ${kmoddir} ${initramfs} ${this.kernel} ${log}`;
    console.log(cmd);
    await exec(cmd, this.echo);
    // clean per btrfs
    let clean = `../../../scripts/99clean ${this.kernel}`;
    await exec(clean, this.echo);
}
