/**
 * ./src/classes/ovary.d/finished.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import chalk from 'chalk';
// packages
import path from 'path';
// _dirname
/**
 * finished = show the results
 * @param scriptOnly
 */
export function finished(scriptOnly = false) {
    // Utils.titles('produce')
    if (scriptOnly) {
        const pathOvarium = path.join(this.settings.config.snapshot_dir, 'bin');
        console.log('eggs is finished!\n\nYou can find the scripts to build iso: ' + chalk.cyanBright(this.settings.isoFilename) + '\nin the bin: ' + chalk.cyanBright(pathOvarium) + '.');
        console.log('usage');
        console.log(chalk.cyanBright(`cd ${pathOvarium}`));
        console.log(chalk.cyanBright('sudo ./bind'));
        console.log('Make all yours modifications in the directories filesystem.squashfs and iso.');
        console.log('After when you are ready:');
        console.log(chalk.cyanBright('sudo ./mksquashfs'));
        console.log(chalk.cyanBright('sudo ./mkisofs'));
        console.log(chalk.cyanBright('sudo ./ubind'));
        console.log('happy hacking!');
    }
    else {
        console.log('eggs is finished!\n\nYou can find the file iso: ' + chalk.cyanBright(this.settings.isoFilename) + '\nin the nest: ' + chalk.cyanBright(this.settings.config.snapshot_dir) + '.');
    }
    console.log();
    console.log('Remember, on liveCD user = ' + chalk.cyanBright(this.settings.config.user_opt) + '/' + chalk.cyanBright(this.settings.config.user_opt_passwd));
    console.log('                    root = ' + chalk.cyanBright('root') + '/' + chalk.cyanBright(this.settings.config.root_passwd));
    if (this.genisoimage) {
        console.log(`Note: format UDF, generated by ${chalk.cyanBright('genisoimage')}`);
    }
}
