/**
 * ./src/classe/ovary.d/luks-interactive-crypto-config.ts
 * penguins-eggs v.25.10.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import Ovary from '../ovary.js';
declare const CIPHER_OPTIONS: readonly ["aes-xts-plain64", "serpent-xts-plain64", "twofish-xts-plain64"];
declare const KEY_SIZE_OPTIONS: readonly [512, 256];
declare const HASH_OPTIONS: readonly ["sha512", "sha256"];
declare const SECTOR_SIZE_OPTIONS: readonly [4096, 512];
declare const ARGON_MEMORY_OPTIONS: readonly [524288, 1048576, 2097152];
declare const ARGON_PARALLEL_OPTIONS: readonly [1, 2, 4, 8];
declare const PBKDF2_ITER_TIME_OPTIONS: readonly [2000, 5000, 10000];
type Cipher = (typeof CIPHER_OPTIONS)[number];
type KeySize = (typeof KEY_SIZE_OPTIONS)[number];
type Hash = (typeof HASH_OPTIONS)[number];
type SectorSize = (typeof SECTOR_SIZE_OPTIONS)[number];
type ArgonPbkdf = 'argon2i' | 'argon2id';
type Pbkdf2Pbkdf = 'pbkdf2';
type ArgonMemory = (typeof ARGON_MEMORY_OPTIONS)[number];
type ArgonParallel = (typeof ARGON_PARALLEL_OPTIONS)[number];
type Pbkdf2IterTime = (typeof PBKDF2_ITER_TIME_OPTIONS)[number];
export interface BaseCryptoConfig {
    cipher: Cipher;
    hash: Hash;
    'key-size': KeySize;
    pbkdf: ArgonPbkdf | Pbkdf2Pbkdf;
    'sector-size': SectorSize;
}
export interface ArgonCryptoConfig extends BaseCryptoConfig {
    pbkdf: ArgonPbkdf;
    'pbkdf-memory (KiB)': ArgonMemory;
    'pbkdf-parallel (threads)': ArgonParallel;
}
export interface Pbkdf2CryptoConfig extends BaseCryptoConfig {
    'iter-time (ms)': Pbkdf2IterTime;
    pbkdf: Pbkdf2Pbkdf;
}
export type CryptoConfig = ArgonCryptoConfig | Pbkdf2CryptoConfig;
/**
 * Runs the interactive prompt to configure LUKS encryption settings.
 * @returns A Promise that resolves to the CryptoConfig object.
 */
export declare function interactiveCryptoConfig(this: Ovary): Promise<CryptoConfig>;
export {};
