/**
 * ./src/classes/ovary.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import { IWorkDir } from '../interfaces/index.js';
import CliAutologin from './cli-autologin.js';
import Incubator from './incubation/incubator.js';
import Settings from './settings.js';
import { fertilization } from './ovary.d/fertilization.js';
import { produce } from './ovary.d/produce.js';
import { bindLiveFs, uBindLiveFs } from './ovary.d/bind-live-fs.js';
import { bindVfs, ubindVfs } from './ovary.d/bind-vfs.js';
import { editLiveFs } from './ovary.d/edit-live-fs.js';
import { makeSquashfs, addExclusion } from './ovary.d/make-squashfs.js';
import { makeEfi } from './ovary.d/make-efi.js';
import { xorrisoCommand } from './ovary.d/xorriso-command.js';
import { createXdgAutostart } from './ovary.d/create-xdg-autostart.js';
import { copied, merged, mergedAndOverlay } from './ovary.d/merged.js';
import { makeIso } from './ovary.d/make-iso.js';
import { initrdAlpine, initrdArch, initrdDebian, initrdDracut } from './ovary.d/initrd.js';
import { userCreateLive } from './ovary.d/user-create-live.js';
import { syslinux } from './ovary.d/syslinux.js';
import { usersRemove } from './ovary.d/users-remove.js';
import { makeDotDisk } from './ovary.d/make-dot-disk.js';
import { kernelCopy } from './ovary.d/kernel-copy.js';
import { liveCreateStructure } from './ovary.d/live-create-structure.js';
import { finished } from './ovary.d/finished.js';
import { luksGetPassword } from './ovary.d/luks-get-password.js';
import { luksHome } from './ovary.d/luks-home.js';
import { installHomecryptSupport } from './ovary.d/luks-home-support.js';
import { luksRoot } from './ovary.d/luks-root.js';
import { createBootstrapFilesystem } from './ovary.d/luks-root-bootstrap-builder.js';
/**
 * Ovary:
 */
export default class Ovary {
    cliAutologin: CliAutologin;
    compression: string;
    clone: boolean;
    homecrypt: boolean;
    fullcrypt: boolean;
    echo: {};
    familyId: string;
    distroId: string;
    distroLike: string;
    distroLliveMediumPath: string;
    genisoimage: boolean;
    incubator: Incubator;
    settings: Settings;
    snapshot_basename: string;
    snapshot_prefix: string;
    theme: string;
    toNull: string;
    verbose: boolean;
    volid: string;
    uuid: string;
    kernel: string;
    initrd: string;
    vmlinuz: string;
    nest: string;
    dotMnt: string;
    dotOverlay: IWorkDir;
    dotLivefs: string;
    luksUuid: string;
    luksName: string;
    luksMappedName: string;
    luksMountpoint: string;
    luksFile: string;
    luksDevice: string;
    luksPassword: string;
    fertilization: typeof fertilization;
    produce: typeof produce;
    addExclusion: typeof addExclusion;
    bindLiveFs: typeof bindLiveFs;
    bindVfs: typeof bindVfs;
    copied: typeof copied;
    createXdgAutostart: typeof createXdgAutostart;
    editLiveFs: typeof editLiveFs;
    luksGetPassword: typeof luksGetPassword;
    luksHome: typeof luksHome;
    installHomecryptSupport: typeof installHomecryptSupport;
    luksRoot: typeof luksRoot;
    createBootstrapFilesystem: typeof createBootstrapFilesystem;
    finished: typeof finished;
    initrdAlpine: typeof initrdAlpine;
    initrdArch: typeof initrdArch;
    initrdDebian: typeof initrdDebian;
    initrdDracut: typeof initrdDracut;
    kernelCopy: typeof kernelCopy;
    liveCreateStructure: typeof liveCreateStructure;
    makeDotDisk: typeof makeDotDisk;
    makeEfi: typeof makeEfi;
    makeIso: typeof makeIso;
    makeSquashfs: typeof makeSquashfs;
    merged: typeof merged;
    mergedAndOverlay: typeof mergedAndOverlay;
    syslinux: typeof syslinux;
    uBindLiveFs: typeof uBindLiveFs;
    ubindVfs: typeof ubindVfs;
    userCreateLive: typeof userCreateLive;
    usersRemove: typeof usersRemove;
    xorrisoCommand: typeof xorrisoCommand;
}
